//
//  Invoking_Block_ObjectsAppDelegate.m
//  Invoking Block Objects
//
//  Created by Vandad Nahavandipoor on 13/07/2011.
//  Copyright 2011 Pixolity Ltd. All rights reserved.
//

#import "Invoking_Block_ObjectsAppDelegate.h"

@implementation Invoking_Block_ObjectsAppDelegate

@synthesize window = _window;

//void (^simpleBlock)(NSString *) = ^(NSString  *paramString){
//  /* Zaimplementuj tutaj obiekt bloku i użyj parametru paramString. */
//};
//
//- (void) callSimpleBlock{
//  
//  simpleBlock(@"Helion");
//  
//}


NSString *(^trimString)(NSString *) = ^(NSString *inputString){
  
  NSString *result = [inputString stringByTrimmingCharactersInSet:
                      [NSCharacterSet whitespaceCharacterSet]];
  return result;
  
};

NSString *(^trimWithOtherBlock)(NSString *) = ^(NSString *inputString){
  return trimString(inputString);
};

- (void) callTrimBlock{
  
  NSString *trimmedString = trimWithOtherBlock(@"   Helion    ");
  NSLog(@"Przycięty ciąg tekstowy = %@", trimmedString);
  
}

- (void) doCalculation{
  
  /* Miejsce na kod przeprowadzający obliczenia. */
  
}

- (void) calculationThreadEntry{
  
  @autoreleasepool {
    NSUInteger counter = 0;
    
    while ([[NSThread currentThread] isCancelled] == NO){
      
      [self doCalculation];
      
      counter++;
      
      if (counter >= 1000){
        break;
      }
      
    }
  }
  
}

- (BOOL)            application:(UIApplication *)application 
  didFinishLaunchingWithOptions:(NSDictionary *)launchOptions{
  
  /* Uruchomienie wątku. */
  [NSThread detachNewThreadSelector:@selector(calculationThreadEntry)
                           toTarget:self
                         withObject:nil];
  
  self.window = [[UIWindow alloc] initWithFrame:[[UIScreen mainScreen] bounds]];
  // Miejsce na przeprowadzenie własnej konfiguracji po uruchomieniu aplikacji.
  self.window.backgroundColor = [UIColor whiteColor];
  [self.window makeKeyAndVisible];
  return YES;
}

- (void)applicationWillResignActive:(UIApplication *)application
{
  /*
   Ta metoda jest wywoływana, gdy aplikacja przechodzi ze stanu aktywnego do nieaktywnego. Może być wywołana w określonych sytuacjach (na przykład w chwili odbywania rozmowy telefonicznej lub po otrzymaniu wiadomości SMS) bądź kiedy użytkownik kończy działanie aplikacji. Metoda rozpoczyna proces przejścia do stanu pozostania w tle. Tę metodę można wykorzystać do wstrzymania wykonywania bieżących zadań, wyłączenia liczników czasu, zmniejszenia liczby klatek generowanych przez OpenGL ES. W grach ta metoda powinna być użyta do wstrzymania gry (pauza).
   */
}

- (void)applicationDidEnterBackground:(UIApplication *)application
{
  /*
   Tę metodę należy wykorzystać do zwolnienia zasobów współdzielonych, zapisania danych użytkownika, wyzerowania liczników czasu oraz do przechowania takiej ilości informacji o stanie, która pozwoli na przywrócenie aplikacji do stanu bieżącego. Jeżeli aplikacja obsługuje działanie w tle, w chwili kończenia działania należy wywołać tę metodę zamiast applicationWillTerminate:.
   */
}

- (void)applicationWillEnterForeground:(UIApplication *)application
{
  /*
   Ta metoda jest wywoływana podczas przechodzenia aplikacji ze stanu aktywnego do działania w tle. Można więc tutaj wycofać wiele zmian wprowadzonych w chwili przechodzenia do stanu działania w tle.
   */
}

- (void)applicationDidBecomeActive:(UIApplication *)application
{
  /*
   W tej metodzie można wznowić działanie zadań zatrzymanych (lub nieuruchomionych), gdy aplikacja była nieaktywna. Jeżeli aplikacja znajdowała się w trybie działania w tle, w metodzie można przeprowadzić odświeżenie interfejsu użytkownika.
   */
}

- (void)applicationWillTerminate:(UIApplication *)application
{
  /*
   Ta metoda jest wywoływana, gdy działanie aplikacji ma zostać zakończone. Zapoznaj się z opisem metody applicationDidEnterBackground:.
   */
}

@end
